Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename randomatic
%global enable_tests 1

Name:		nodejs-randomatic
Version:	1.1.5
Release:	alt1_10
Summary:	Generate randomized strings of a specified length

License:	MIT
URL:		https://github.com/jonschlinkert/randomatic.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	https://raw.githubusercontent.com/jonschlinkert/randomatic/1.1.5/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(is-number)
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
Generate randomized strings of a specified length, fast. Only the length is
necessary, but you can optionally generate patterns using any combination of
numeric, alpha-numeric, alphabetical, special or custom characters.


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .
# remove executable bit from LICENSE
chmod -x LICENSE

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
