Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-range-parser
Version:    1.2.0
Release:    alt1_6
Summary:    Range header field string parser for Node.js
License:    MIT
URL:        https://github.com/visionmedia/node-range-parser
Source0:    http://registry.npmjs.org/range-parser/-/range-parser-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:    https://raw.githubusercontent.com/jshttp/range-parser/v%{version}/test/range-parser.js

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
mkdir -p test/
cp -p %{SOURCE1} test/range-parser.js


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/range-parser
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/range-parser

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec --require should
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/range-parser


%changelog
