Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename read-file
%global enable_tests 1

Name:		nodejs-read-file
Version:	0.2.0
Release:	alt1_8
Summary:	Thin wrapper around fs.readFile and fs.readFileSync

License:	MIT
URL:		https://github.com/jonschlinkert/read-file
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/jonschlinkert/read-file/master/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Thin wrapper around fs.readFile and fs.readFileSync that also strips byte order
marks when `utf8` encoding is chosen. Also optionally replaces windows newlines
with unix newlines.


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .

mkdir fixtures
echo -n "FILE CONTENTS!!!" > fixtures/a.txt

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
