# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-read-installed
Version:        4.0.3
Release:        alt1_6
Summary:        Returns a tree structure of all installed packages in a folder

Group:          System/Libraries
License:        ISC
URL:            https://github.com/isaacs/read-installed
# Need to use github as tests are incomplete in npmjs tar ball
Source0:        https://github.com/npm/read-installed/archive/v%{version}/%{name}-%{version}.tar.gz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(tap)
BuildRequires:  npm(debuglog)
BuildRequires:  npm(graceful-fs)
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(read-package-json)
BuildRequires:  npm(readdir-scoped-modules)
BuildRequires:  npm(rimraf)
BuildRequires:  npm(semver)
BuildRequires:  npm(slide)
BuildRequires:  npm(util-extend)

Requires:       npm(graceful-fs) >= 4.1.2
Source44: import.info

%description
Reads all the installed packages in a folder, and returns a tree structure with
all the data.


%prep
%setup -q -n read-installed-%{version}



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/read-installed
cp -pr package.json read-installed.js %{buildroot}%{nodejs_sitelib}/read-installed
%nodejs_symlink_deps


%check
exit 0
%nodejs_symlink_deps --check
ln -s %{nodejs_sitelib}/graceful-fs node_modules
tap test/*.js


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/read-installed


%changelog
