Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename readdir-enhanced

# Tests fail in NodeJS 10.x
%global enable_tests 0

Name:		nodejs-readdir-enhanced
Version:	2.2.1
Release:	alt1_6
Summary:	A fs.readdir with sync, async, and streaming APIs

License:	MIT
URL:		https://github.com/bigstickcarpet/readdir-enhanced.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(call-me-maybe)
BuildRequires:	npm(glob-to-regexp)

%if 0%{?enable_tests}
BuildRequires:	node-mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(del)
BuildRequires:	npm(mkdirp)
BuildRequires:	npm(through2)
%endif
Source44: import.info

%description
A fs.readdir with sync, async, and streaming APIs + filtering, recursion,
absolute paths, etc.


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package



%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
