Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-repl
Version:        0.1.3
Release:        alt1_15
Summary:        A lightweight templating library for Node.js
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

# package.json indicates MIT, but no license file included
# upstream notified in https://github.com/firejune/repl/pull/1
# we're including a copy of the MIT license in order to comply with the terms of 
# the MIT license, as required by:
# https://fedoraproject.org/wiki/Packaging:LicensingGuidelines#License_Text
License:        MIT
URL:            https://github.com/firejune/repl
Source0:        https://registry.npmjs.org/repl/-/repl-%{version}.tgz
Source1:        https://raw.github.com/tchollingsworth/repl/8658350d7c0d1d4577f1a802de7032803c934301/LICENSE
BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
%{summary}.

%prep
%setup -q -n package

#copy LICENSE file to %%{_builddir} so it works with %%doc
cp %{SOURCE1} .

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/repl
cp -pr lib index.js package.json %{buildroot}%{nodejs_sitelib}/repl

%nodejs_symlink_deps

%check
%{__nodejs} test.js

%files
%{nodejs_sitelib}/repl
%doc README.md
%doc --no-dereference LICENSE

%changelog
