Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global modname replace

%if ! ( 0%{?fedora} || 0%{?rhel} >= 7 )

%global nodejs_arches %{ix86} x86_64 %{arm}
%endif

Name:           nodejs-%{modname}
Version:        1.1.1
Release:        alt1_2
Summary:        Command line search and replace utility using Nodejs
License:        MIT
URL:            https://github.com/ALMaclaine/replace
Source0:        http://registry.npmjs.org/%{modname}/-/%{modname}-%{version}.tgz
BuildArch:      noarch
BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(tap)
BuildRequires:  npm(tape)
BuildRequires:  npm(yargs)
BuildRequires:  npm(colors)
BuildRequires:  npm(minimatch)
Source44: import.info

%description
replace is a command line utility for performing search-and-replace on files. 
It's similar to sed but there are a few differences:
* Modifies files when matches are found
* Recursive search on directories with -r
* Uses JavaScript syntax for regular expressions and replacement strings.

%prep
%setup -q -n package
%nodejs_fixdep yargs
%nodejs_fixdep colors
%nodejs_fixdep minimatch

%build
# nothing to do

%check
%nodejs_symlink_deps --check
tap test

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{modname}
cp -pr package.json replace.js defaultignore bin/ \
    %{buildroot}%{nodejs_sitelib}/%{modname}/
# Not installing to /usr/bin for now, because search and replace both conflict 
# with existing packages:
# https://github.com/harthur/replace/issues/34
%nodejs_symlink_deps

%files
%doc README.md LICENSE
%{nodejs_sitelib}/%{modname}

%changelog
