Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:       nodejs-require-cs
Version:    0.4.4
Release:    alt1_10
Summary:    An AMD loader plugin for CoffeeScript
# Upstream have been informed of missing licenses:
# https://github.com/jrburke/require-cs/issues/44
License:    MIT or BSD
URL:        https://github.com/jrburke/require-cs
Source0:    https://github.com/jrburke/require-cs/archive/%{version}.tar.gz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

# package.json declares the name as 'cs', but this name is already taken in
# the npm registry so rename to 'require-cs' instead.
Patch0:     %{name}-0.4.3-change-name.patch

BuildRequires:  rpm-build-nodejs node-devel
# We are symlinking to these files, so explicitly depend on them just in case
# the packages that own them decide to move them somewhere else.
Requires:       /usr/share/coffee-script/extras/coffee-script.js
Requires:       /usr/lib/node_modules/requirejs/bin/r.js
Source44: import.info

%description
A CoffeeScript loader plugin that may work with module loaders like
RequireJS, curl and backdraft.

This loader plugin makes it easy to write your JS functionality in
CoffeeScript, and easily use it in the browser, Node or Rhino. Plus,
if you use the RequireJS optimizer, your CoffeeScript files can be
translated to JavaScript and in-lined into optimized layers for fast
performance.


%prep
%setup -q -n require-cs-%{version}
%patch0 -p1
rm -f coffee-script.js
rm -rf tools/


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/require-cs
cp -pr package.json cs.js \
    %{buildroot}%{nodejs_sitelib}/require-cs

# Replace bundled coffee-script.js with symlink.
ln -sf %{_datadir}/coffee-script/extras/coffee-script.js \
    %{buildroot}%{nodejs_sitelib}/require-cs/coffee-script.js

# Replace bundled tools/r.js with symlink.
mkdir -p %{buildroot}%{nodejs_sitelib}/require-cs/tools
ln -sf %{nodejs_sitelib}/requirejs/bin/r.js \
    %{buildroot}%{nodejs_sitelib}/require-cs/tools/r.js

%nodejs_symlink_deps


%files
%doc LICENSE README.md demo/ demoserver.js
%{nodejs_sitelib}/require-cs


%changelog
