Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#disabled as ava module upstream not found
%global enable_tests 0
%global module_name require-uncached

Name:           nodejs-%{module_name}
Version:        1.0.3
Release:        alt1_8
Summary:        Require a module bypassing the cache

License:        MIT
URL:            https://github.com/sindresorhus/require-uncached
Source0:        http://registry.npmjs.org/%{module_name}/-/%{module_name}-%{version}.tgz
# Please note upstream renamed this project to import-fresh module
Source1:        https://raw.githubusercontent.com/sindresorhus/import-fresh/v%{version}/license
Source2:        https://raw.githubusercontent.com/sindresorhus/import-fresh/v%{version}/test.js
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(caller-path)
BuildRequires:  npm(resolve-from)

%if 0%{?enable_tests}
BuildRequires:  npm(ava)
%endif
Source44: import.info


%description
Useful for testing purposes when you need to freshly require a module.

%prep
%setup -q -n package

rm -rf node_modules

cp -p %{SOURCE1} %{SOURCE2} .

%nodejs_fixdep caller-path
%nodejs_fixdep resolve-from

%build
# nothing to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{module_name}
cp -pr package.json *.js %{buildroot}%{nodejs_sitelib}/%{module_name}
%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
node test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc readme.md 
%doc --no-dereference license
%{nodejs_sitelib}/%{module_name}

%changelog
