Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename require-yaml
%global enable_tests 1

Name:		nodejs-require-yaml
Version:	0.0.1
Release:	alt1_8
Summary:	Lets you load YAML/YML files using require syntax

License:	BSD
URL:		https://github.com/olalonde/require-yaml
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# License file
Source1:	https://raw.githubusercontent.com/olalonde/require-yaml/master/LICENSE


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(js-yaml)

%if 0%{?enable_tests}
#BuildRequires:
%endif
Source44: import.info

%description
require('require-yaml') lets you load YAML/YML files using require syntax. For
example: var config = require('./config.yaml');


%prep
%setup -q -n package

# copy license file
cp -p %{SOURCE1} .

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
echo -e "\e[103m -=#=- This package has no tests -=#=- \e[0m"
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
