Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# Pass outside mock, getting ECONNREFUSED inside mock.
%global enable_tests 0

Name:       nodejs-send
Version:    0.16.1
Release:    alt1_5
Summary:    Better streaming static file server with Range and conditional-GET support
License:    MIT
URL:        https://github.com/visionmedia/send
Source0:    https://registry.npmjs.org/send/-/send-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

# fix directory traversal vulnerability (RHBZ#1146063)
#Patch1:     nodejs-send-root-traversal.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(debug)
BuildRequires:  npm(depd)
BuildRequires:  npm(destroy)
BuildRequires:  npm(encodeurl)
BuildRequires:  npm(escape-html)
BuildRequires:  npm(etag)
BuildRequires:  npm(fresh)
BuildRequires:  npm(http-errors)
BuildRequires:  npm(mime)
BuildRequires:	npm(on-finished)
BuildRequires:  npm(range-parser)

%if 0%{?enable_tests}
BuildRequires:  npm(after)
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
Send is Connect's static() extracted for generalized use, a streaming static
file server supporting partial responses (Ranges), conditional-GET
negotiation, high test coverage, and granular events which may be leveraged
to take appropriate actions in your application or framework.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
#%patch1 -p1

%nodejs_fixdep debug
%nodejs_fixdep range-parser '^1.0'
%nodejs_fixdep depd '~1.1'
%nodejs_fixdep escape-html '~1.0.3'
%nodejs_fixdep mime



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/send
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/send

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha --require should --reporter spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc HISTORY.md README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/send


%changelog
