Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename sequencify
%global enable_tests 1

Name:		nodejs-sequencify
Version:	0.0.7
Release:	alt1_8
Summary:	A module for sequencing tasks and dependencies

License:	MIT
URL:		https://github.com/robrich/sequencify.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# Tests aren't part of the npm tarball, and there are no tags in the github repo
# This git tag corresponds with version 0.0.7
Source1:	https://raw.githubusercontent.com/robrich/sequencify/df3e382c496ff4b505d992c0e0320d46353594b0/test/index.js

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
A module for sequencing tasks and dependencies


%prep
%setup -q -n package
# setup the tests
mkdir test/
cp -p %{SOURCE1} test/

# fix the 'should' syntax for the tests
sed -i -e 's/should.include/should.containEql/' test/index.js


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
