Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-serve-index
Version:    1.0.1
Release:    alt1_13
Summary:    Middleware for serving directory listings for Node.js and Connect
License:    MIT
URL:        https://github.com/expressjs/serve-index
Source0:    http://registry.npmjs.org/serve-index/-/serve-index-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(batch)
BuildRequires:  npm(connect)
BuildRequires:  npm(mocha)
BuildRequires:  npm(negotiator)
BuildRequires:  npm(should)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package

%nodejs_fixdep batch '~0.5'
%nodejs_fixdep negotiator '~0.4'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/serve-index
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/serve-index

mkdir -p %{buildroot}%{_datadir}/%{name}
cp -pr public/ %{buildroot}%{_datadir}/%{name}
ln -sf %{_datadir}/%{name}/public \
    %{buildroot}%{nodejs_sitelib}/serve-index/public

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha --require should --reporter spec
%endif


%files
%doc LICENSE Readme.md
%{nodejs_sitelib}/serve-index
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/public


%changelog
