# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-serve-static
Version:    1.1.0
Release:    alt1_6
Summary:    Middleware for serving static files for Node.js and Connect
License:    MIT
Group:      System/Libraries
URL:        https://github.com/expressjs/serve-static
Source0:    http://registry.npmjs.org/serve-static/-/serve-static-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(connect)
BuildRequires:  npm(mocha)
BuildRequires:  npm(parseurl)
BuildRequires:  npm(send)
BuildRequires:  npm(should)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package

%nodejs_fixdep parseurl '~1.0'
%nodejs_fixdep send '~0.3'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/serve-static
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/serve-static

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha --require should --reporter spec
%endif


%files
%doc History.md LICENSE Readme.md
%{nodejs_sitelib}/serve-static


%changelog
