Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename set-getter
%global enable_tests 1

Name:		nodejs-set-getter
Version:	0.1.0
Release:	alt1_8
Summary:	Create nested getter properties and any intermediary paths

License:	MIT
URL:		https://github.com/doowb/set-getter
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# The author hasn't tagged releases in Github, so pull tests and examples from master
Source1:	https://raw.githubusercontent.com/doowb/set-getter/master/test.js
Source2:	https://raw.githubusercontent.com/doowb/set-getter/master/example.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(to-object-path)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Create nested getter properties and any intermediary dot notation (`'a.b.c'`)
paths


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .
# setup the example
cp -p %{SOURCE2} .


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md example.js
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
