Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:           nodejs-shelljs
Version:        0.8.4
Release:        alt1_2
Summary:        Portable Unix shell commands for Node.js

# The bulk of the project is licensed under BSD license.
# src/cp.js and src/rm.js contain MIT licensed code.
# https://fedorahosted.org/fpc/ticket/413
License:        BSD and MIT
URL:            http://github.com/arturadib/shelljs
Source0:        http://github.com/arturadib/shelljs/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(glob)

%if 0%{?enable_tests}
BuildRequires:  coffee-script
BuildRequires:  npm(ava)
%endif
Source44: import.info

%description
%{summary}.

%prep
%setup -q -n shelljs-%{version}

sed -i '1s/env //' bin/shjs
%nodejs_fixdep glob

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/shelljs
cp -pr package.json commands.js global.js make.js plugin.js shell.js src/ \
    %{buildroot}%{nodejs_sitelib}/shelljs
mkdir -p %{buildroot}%{nodejs_sitelib}/shelljs/bin
install -p -m0755 bin/shjs %{buildroot}%{nodejs_sitelib}/shelljs/bin
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/shelljs/bin/shjs %{buildroot}%{_bindir}/shjs
%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
ava test/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc --no-dereference LICENSE
%doc CHANGELOG.md CONTRIBUTING.md README.md RELEASE.md
%{nodejs_sitelib}/shelljs
%{_bindir}/shjs

%changelog
