Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 1

%global barename smart-buffer

Name:               nodejs-smart-buffer
Version:            1.0.3
Release:            alt1_8
Summary:            A smarter Buffer

License:            MIT
URL:                https://www.npmjs.org/package/smart-buffer
Source0:            https://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora}
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(chai)
BuildRequires:      npm(mocha)
%endif
Source44: import.info

%description
smart-buffer is a light Buffer wrapper that takes away the need to keep
track of what position to read and write data to and from the underlying
Buffer. It also adds null terminating string operations and **grows** as
you add more data.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
# %%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/smart-buffer
cp -pr package.json lib \
    %{buildroot}%{nodejs_sitelib}/smart-buffer

%nodejs_symlink_deps

%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
mocha test/test.js
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/smart-buffer/

%changelog
