Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-snockets
Version:    1.3.8
Release:    alt2_15
Summary:    A JavaScript/CoffeeScript concatenation tool for Node.js inspired by Sprockets
# License text is included in README.mdown.
License:    MIT
URL:        https://github.com/TrevorBurnham/snockets
Source0:    http://registry.npmjs.org/snockets/-/snockets-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  coffee-script
BuildRequires:  npm(docco)
BuildRequires:  npm(dep-graph)
BuildRequires:  npm(watchit)
BuildRequires:  npm(uglify-js) < 2

%if 0%{?enable_tests}
BuildRequires:  npm(nodeunit)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
# Compile from source instead.
rm -rf lib/

%nodejs_fixdep dep-graph '~1.1'
%nodejs_fixdep mime
%nodejs_fixdep uglify-js '~1.3'
%nodejs_fixdep underscore '~1.4'


%build
%nodejs_symlink_deps --check
/usr/bin/cake build
rm -rf node_modules

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/snockets
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/snockets

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
sed -i -e "/invoke 'docs'/d" Cakefile
/usr/bin/cake test
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif



%files
%doc README.mdown docs/
%{nodejs_sitelib}/snockets


%changelog
