Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:           nodejs-sntp
Epoch:          1
Version:        2.0.1
Release:        alt1_9
Summary:        SNTP v4 client (RFC4330) for Node.js

License:        BSD
URL:            https://github.com/hueniverse/sntp
Source0:        https://github.com/hueniverse/sntp/archive/v%{version}/sntp-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(hoek)
Source44: import.info

%description
An SNTP v4 client (RFC4330) for Node.js. Simply connects to the NTP or SNTP
server requested and returns the server time along with the round-trip duration
and clock offset. To adjust the local time to the NTP time, add the returned 
time offset to the local time.


%prep
%setup -q -n sntp-%{version}

%{nodejs_fixdep} hoek

#drop exec bit from everything
chmod 0644 *.js* README.md LICENSE examples/* lib/*


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/sntp
cp -pr lib package.json %{buildroot}%{nodejs_sitelib}/sntp
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"
%if 0%{?enable_tests}
#Yet Another Unpackaged Test Framework (lab)
#make test
%endif


%files
%{nodejs_sitelib}/sntp
%doc README.md examples
%doc --no-dereference LICENSE


%changelog
