Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename spawn-wrap

# tests disabled because the depend on a newer version of npm(tap)
%global enable_tests 0

Name:		nodejs-spawn-wrap
Version:	1.3.8
Release:	alt1_6
Summary:	Wrap all spawned Node.js child processes with environs and args

License:	ISC
URL:		https://github.com/isaacs/spawn-wrap.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(os-homedir)
BuildRequires:	npm(mkdirp)
BuildRequires:	npm(rimraf)
BuildRequires:	npm(signal-exit)
BuildRequires:	npm(which)
%if 0%{?enable_tests}
BuildRequires:	npm(foreground-child)
BuildRequires:	npm(tap)
%endif
Source44: import.info

%description
Wrap all spawned Node.js child processes by adding environs and arguments ahead
of the main JavaScript file argument.


%prep
%setup -q -n package
# tests
%setup -q -T -D -a 1 -n package

%nodejs_fixdep signal-exit

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/tap test/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
