Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# spec file for package nodejs-nodejs-spdx-license-ids

%global npm_name spdx-license-ids


%global enable_tests 0
# tests are disabled because they depend on a newer version of nodejs

Name:		nodejs-spdx-license-ids
Version:	1.2.0
Release:	alt1_11
Summary:	A list of SPDX license identifiers
Url:		https://github.com/shinnn/spdx-license-ids
Source0:        https://registry.npmjs.org/%{npm_name}/-/%{npm_name}-%{version}.tgz
Source1:	https://spdx.org/licenses/licenses.json
# The list in this package is built from the list at spdx.org, but
# unfortunately the build instructions for this package depend on a newer
# version of nodejs and on direct network access, so we'll have to come up
# with our own way of building the list using tools already in Fedora
Source2:	https://raw.githubusercontent.com/shinnn/spdx-license-ids/v1.2.0/test.js
# the test file is not included in the NPM package

License:	Unlicense
# Yes, this is the "Unlicense" license

BuildArch:	noarch

BuildRequires:	jq libjq
BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:	npm(rimraf)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
A list of SPDX license identifiers

%prep
%setup -q -n package
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .

chmod -x README.md

# Remove the generated file and rebuild from source as part of the %%build step
rm spdx-license-ids.json

%build
# Use the jq tool to rebuild the list from the source file, rather than using
# the upstream method of running 'build.js', because 'build.js' depends on a
# newer version of nodejs and also requires network connectivity.
%{_bindir}/jq '[.licenses[].licenseId] | map(select(endswith("+")|not))' licenses.json > spdx-license-ids.json

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npm_name}

cp -pr package.json spdx-license-ids.json %{buildroot}%{nodejs_sitelib}/%{npm_name}

%{nodejs_symlink_deps}

%check
%{nodejs_symlink_deps} --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{__nodejs} --harmony_arrow_functions test.js
%endif

%files
%{!?_licensedir:%global license %doc}
%{nodejs_sitelib}/spdx-license-ids
%doc README.md
%doc --no-dereference LICENSE

%changelog
