Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global barename stringset

Name:               nodejs-stringset
Version:            0.2.1
Release:            alt1_11
Summary:            Fast and robust stringset

License:            MIT
URL:                https://www.npmjs.org/package/stringset
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel
Source44: import.info

%description
A fast and robust stringset implementation that can hold any string items,
including __proto__, with minimal overhead compared to a plain object. Works in
node and browsers.

The API is created to be as close to the ES6 Set API as possible. Prefer
ss.remove("key") for deleting a key. ES6 Set uses set.delete("key") instead and
for that reason ss['delete']("key") is available as a stringset alias as well.
Never do ss.delete("key") unless you're certain to be in the land of ES5 or
later.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/stringset
cp -pr package.json examples.js stringset.js \
    %{buildroot}%{nodejs_sitelib}/stringset

%nodejs_symlink_deps

%files
%doc LICENSE README.md
%{nodejs_sitelib}/stringset/

%changelog
