Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npm_name supervisor



Summary:       A supervisor program for running nodejs programs
Name:          nodejs-%{npm_name}
Version:       0.12.0
Release:       alt2_12
License:       MIT
URL:           https://github.com/isaacs/node-supervisor
Source0:       http://registry.npmjs.org/%{npm_name}/-/%{npm_name}-%{version}.tgz
BuildRequires: node-devel rpm-build-nodejs
BuildRequires: txt2man
BuildArch:     noarch
Source44: import.info

%description
A little supervisor script for nodejs. It runs your program,
and watches for code changes, so you can have hot-code 
reloading like behavior, without worrying about memory leaks 
and making sure you clean up all the inter-module references, 
and without a whole new require system. 

%prep
%setup -q -n package

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npm_name}
cp -pr lib package.json %{buildroot}%{nodejs_sitelib}/%{npm_name}

# Setup Binaries
mkdir %{buildroot}%{_bindir}
ln -s %{nodejs_sitelib}/%{npm_name}/lib/cli-wrapper.js %{buildroot}%{_bindir}/node-supervisor
ln -s %{nodejs_sitelib}/%{npm_name}/lib/cli-wrapper.js %{buildroot}%{_bindir}/supervisor

# Create man pages
mkdir -p %{buildroot}%{_mandir}/man1
%{buildroot}%{nodejs_sitelib}/%{npm_name}/lib/cli-wrapper.js -h > helpfile
txt2man -P node-supervisor -t node-supervisor -r %{version} helpfile > %{buildroot}%{_mandir}/man1/node-supervisor.1
txt2man -P supervisor -t supervisor -r %{version} helpfile > %{buildroot}%{_mandir}/man1/supervisor.1
rm -f helpfile

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{npm_name}
%{_bindir}/node-supervisor
%{_bindir}/supervisor
%{_mandir}/man1/*

%changelog
