%filter_from_requires /^npm(--caret)/d
%filter_from_requires /^.usr.lib.node_modules.--caret/d
Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global barename supports-color
%global enable_tests 0
# tests disabled until such time as 'ava' is packaged in Fedora


Name:               nodejs-supports-color
Version:            4.4.0
Release:            alt1_4
Summary:            Detect whether a terminal supports color

License:            MIT
URL:                https://github.com/chalk/supports-color
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz

# 4.4.0 release hasn't been tagged in github yet
#Source1:            https://raw.githubusercontent.com/chalk/supports-color/v%{version}/test.js
Source1:            https://raw.githubusercontent.com/chalk/supports-color/master/test.js

BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel
BuildRequires:      npm(has-flag)

%if 0%{?enable_tests}
BuildRequires:      npm(require-uncached)
BuildRequires:      npm(mocha)
%endif
Source44: import.info


%description
Detect whether a terminal supports color

%prep
%setup -q -n package
cp %{SOURCE1} .

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
# This causes warnings when running the tests
#nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/supports-color
cp -pr package.json *.js \
    %{buildroot}%{nodejs_sitelib}/supports-color

%nodejs_symlink_deps
mkdir -p %{buildroot}/%{_bindir}/
#ln -s %{nodejs_sitelib}/supports-color/cli.js \
#    %{buildroot}/%{_bindir}/supports-color


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference license
%doc readme.md
%{nodejs_sitelib}/supports-color/
#%{_bindir}/supports-color

%changelog
