Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 1

Name:           nodejs-tap
Version:        0.7.1
Release:        alt1_9
Summary:        A Test Anything Protocol library

License:        MIT
URL:            https://github.com/isaacs/node-tap
Source0:        https://registry.npmjs.org/tap/-/tap-%{version}.tgz
Source1:        macros.nodejs-tap

BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
# we need to replicate the dependencies of this package for it to be able to
# test itself
BuildRequires:  gcc
BuildRequires:  npm(buffer-equal)
BuildRequires:  npm(deep-equal)
BuildRequires:  npm(difflet)
BuildRequires:  npm(glob)
BuildRequires:  npm(inherits) = 1.0.0
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(nopt)
BuildRequires:  npm(runforcover)
BuildRequires:  npm(slide)
BuildRequires:  npm(yamlish)
%endif
Source44: import.info

%description
This is a mix-and-match set of utilities that you can use to write test
harnesses and frameworks that communicate with one another using the
Test Anything Protocol.

%prep
%setup -q -n package
#%%patch1 -p1

%nodejs_fixdep deep-equal '^1.0.1'
%nodejs_fixdep glob '^6.0.3'
%nodejs_fixdep inherits 1
%nodejs_fixdep nopt '^3.0.6'

#remove bundled modules
rm -rf node_modules

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/tap
cp -pr bin lib package.json %{buildroot}%{nodejs_sitelib}/tap

mkdir -p %{buildroot}%{_bindir}
ln -sf ../lib/node_modules/tap/bin/tap.js %{buildroot}%{_bindir}/tap

#install some macros for use in RPM %%check sections
install -Dpm0644 %{SOURCE1} %{buildroot}%{_rpmmacrosdir}/tap

#make secondary scripts executable
chmod 0755 %{buildroot}%{nodejs_sitelib}/tap/bin/*

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%if 0%{?enable_tests}
%{__nodejs} -e 'require("./")'

# Temporarily disable test/segv.js
rm -f test/debug-test.js

%__nodejs %{buildroot}%{nodejs_sitelib}/tap/bin/tap.js test/*.js
%endif

%files
%{nodejs_sitelib}/tap
%{_bindir}/tap
%{_rpmmacrosdir}/tap
%doc coverage-example example README.md AUTHORS LICENSE

%changelog
