Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename tildify

# tests disabled due to missing npm(ava) test suite
%global enable_tests 0

Name:		nodejs-tildify
Version:	1.2.0
Release:	alt1_9
Summary:	Convert an absolute path to a tilde path

License:	MIT
URL:		https://github.com/sindresorhus/tildify
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/tildify/v%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(os-homedir)

%if 0%{?enable_tests}
BuildRequires:	npm(ava)
%endif
Source44: import.info

%description
Convert an absolute path to a tilde path: `/Users/sindresorhus/dev` a.. `~/dev`


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/ava
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}

%changelog
