Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with internet

Name:           nodejs-tilejson
Version:        1.0.3
Release:        alt1_6
Summary:        Tile source backend for online tile sources

License:        BSD
URL:            https://github.com/mapbox/node-tilejson
Source0:        https://registry.npmjs.org/tilejson/-/tilejson-%{version}.tgz
# Remove tests that need internet access
Patch0:         nodejs-tilejson-internet.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(tape) >= 3.0.0
BuildRequires:  npm(agentkeepalive)
BuildRequires:  npm(requestretry)
BuildRequires:  npm(tiletype) >= 0.1.0
Source44: import.info

%description
%summary


%prep
%setup -q -n package
%if ! %{with internet}
%patch0 -p1
%endif
%nodejs_fixdep agentkeepalive "^3.0.0"
%nodejs_fixdep tiletype "^0.3.0"
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/tilejson
cp -pr package.json lib %{buildroot}/%{nodejs_sitelib}/tilejson
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/tape/bin/tape test/*.test.js


%files
%doc --no-dereference LICENSE
%{nodejs_sitelib}/tilejson


%changelog
