Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename tlds
%global enable_tests 1

Name:		nodejs-tlds
Version:	1.197.0
Release:	alt1_6
Summary:	List of TLDs

License:	MIT
URL:		https://github.com/stephenmathieson/node-tlds
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/stephenmathieson/node-tlds/%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?enable_tests}
#BuildRequires:
%endif
Source44: import.info

%description
List of TLDs


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .
# Create license file from the end of Readme.md
sed -e '0,/^## License/d' Readme.md > LICENSE.md

# fix script interpreter in bin.js
sed -i '1!b;s/env node/node/' bin.js

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%__nodejs test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}

%changelog
