Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename to-object-path
%global enable_tests 1

Name:		nodejs-to-object-path
Version:	0.3.0
Release:	alt1_8
Summary:	Create an object path from a list or array of strings

License:	MIT
URL:		https://github.com/jonschlinkert/to-object-path
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Release not tagged in Github, pulling from master instead
Source1:	https://raw.githubusercontent.com/jonschlinkert/to-object-path/master/test.js
Source2:	https://raw.githubusercontent.com/jonschlinkert/to-object-path/master/example.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(kind-of)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Create an object path from a list or array of strings.


%prep
%setup -q -n package

# setup the tests and examples
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md example.js
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
