Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

%if 0%{?fedora}
%global installdir  %{_jsdir}/underscore
%else
%global installdir  %{_datadir}/javascript/underscore
%endif

Name:       nodejs-underscore
Version:    1.13.1
Release:    alt1_1
Summary:    JavaScript's functional programming helper library
License:    MIT
URL:        http://underscorejs.org/
Source0:    http://registry.npmjs.org/underscore/-/underscore-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

%if 0%{?fedora}
BuildRequires:  web-assets-devel
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  node-uglify-js

%if 0%{?enable_tests}
BuildRequires:  npm(phantomjs)
%endif
Source44: import.info

%description
Underscore.js is a utility-belt library for JavaScript that provides support
for the usual functional suspects (each, map, reduce, filter...) without
extending any core JavaScript objects.

%package -n js-underscore
Group: Development/Other
Summary:    JavaScript's functional programming helper library
%if 0%{?fedora}
Requires:   web-assets-filesystem
%endif

%description -n js-underscore
Underscore.js is a utility-belt library for JavaScript that provides support
for the usual functional suspects (each, map, reduce, filter...) without
extending any core JavaScript objects.

%prep
%setup -q -n package
%setup -T -D -a 1 -q -n package
rm -f underscore-min.*


%build
/usr/bin/uglifyjs underscore.js -m --source-map -o underscore-min.js


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/underscore
cp -pr package.json underscore.js underscore-min.js underscore-min.js.map \
    %{buildroot}%{nodejs_sitelib}/underscore

# Install browser version
mkdir -p %{buildroot}%{installdir}
cp -pr underscore.js underscore-min.js underscore-min.js.map \
    %{buildroot}%{installdir}

# No dependencies.
# %%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/phantomjs/bin/phantomjs \
    test/vendor/runner.js test/index.html?noglobals=true
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/underscore

%files -n js-underscore
%doc LICENSE README.md
%{installdir}


%changelog
