Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-underscore-dot-logger
Version:    0.3.1
Release:    alt1_15
Summary:    Cross-browser and Node.js empowered logging
# License text is included in README.md
License:    MIT
URL:        https://npmjs.org/package/underscore.logger
Source0:    http://registry.npmjs.org/underscore.logger/-/underscore.logger-%{version}.tgz

# package.json is missing devDependencies section.
# Pull request sent: https://github.com/viatropos/underscore.logger/pull/3
Patch0:     %{name}-0.3.1-Add-devDependencies.patch
# Recent versions of coffee-script enforce strict JS compliance.
# Pull request sent: https://github.com/viatropos/underscore.logger/pull/4
Patch1:     %{name}-0.3.1-strict-JS-compliance.patch
Patch2:     %{name}-0.3.1-strict-JS-compliance-part-2.patch
# The author uses the "--watch" option in Cakefile, which obviously hangs the
# build.
Patch3:     %{name}-0.3.1-Do-not-watch.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  coffee-script

%if 0%{?enable_tests}
BuildRequires:  npm(jasmine-node)
BuildRequires:  npm(underscore)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
# Compile from .coffee source instead.
rm -rf lib/*.js


%build
%nodejs_symlink_deps --check
/usr/bin/cake coffee


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/underscore.logger
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/underscore.logger

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
/usr/bin/cake spec
%endif


%files
%doc README.md
%{nodejs_sitelib}/underscore.logger


%changelog
