Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename unique-filename
%global enable_tests 1

Name:		nodejs-unique-filename
Version:	1.1.0
Release:	alt1_9
Summary:	Generate a unique filename for use in temporary directories or caches

License:	ISC
URL:		https://github.com/iarna/unique-filename.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Source1:	LICENSE-ISC.txt
# Upstream does not have a license file

Patch0:		nodejs-unique-filename_fix-tests.patch
# the version of npm(tap) in Fedora is *very* old, so we have to patch the
# syntax to fit the old version of tap.  If tap gets updated, we can remove
# this patch.


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(unique-slug)
%if 0%{?enable_tests}
BuildRequires:	npm(tap)
%endif
Source44: import.info

%description
Generate a unique filename for use in temporary directories or caches.


%prep
%setup -q -n package
%patch0 -p1
cp -p %{SOURCE1} .


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/tap test
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-ISC.txt
%{nodejs_sitelib}/%{packagename}


%changelog
