Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename unique-slug
%global enable_tests 1

Name:		nodejs-unique-slug
Version:	2.0.0
Release:	alt1_10
Summary:	Generate a unique character string suitable for use in files and URLs

License:	ISC
URL:		https://github.com/iarna/unique-slug.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Source1:	LICENSE-ISC.txt
# No upstream license file, but one has been requested
# at https://github.com/npm/unique-slug/issues/2

Patch0:		nodejs-unique-slug_fix_tests.patch
# the version of npm(tap) in Fedora is *very* old, so we have to patch the
# syntax to fit the old version of tap.  If tap gets updated, we can remove
# this patch.

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(imurmurhash)
%if 0%{?enable_tests}
BuildRequires:	npm(tap)
%endif
Source44: import.info

%description
Generate a unique character string suitable for use in files and URLs.


%prep
%setup -q -n package
cp -p %{SOURCE1} .
%patch0 -p1


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/tap --coverage test
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-ISC.txt
%{nodejs_sitelib}/%{packagename}


%changelog
