Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-url2
Version:    1.0.0
Release:    alt1_11
Summary:    The Node.js URL module plus relative paths
License:    MIT
URL:        https://github.com/kriskowal/url2
Source0:    http://registry.npmjs.org/url2/-/url2-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(jasmine-node)
%endif
Source44: import.info

%description
This module builds upon the existing URL module in Node.js, but adds
relative(source, target) which returns the shortest relative path between
any two equally qualified URLs. If the paths are not equally qualified,
it returns the target.

In addition, this package augments the URL object definition as returned
by parse and consumed by format.


%prep
%setup -q -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/url2
cp -pr package.json url2.js \
    %{buildroot}%{nodejs_sitelib}/url2

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/jasmine-node/bin/jasmine-node test
%endif


%files
%doc LICENSE.md README.md
%{nodejs_sitelib}/url2


%changelog
