Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-vows
Version:        0.8.3
Release:        alt1_2
Summary:        Asynchronous behavior-driven development (BDD) and continuous integration

License:        MIT
URL:            https://github.com/cloudhead/vows
Source0:        http://registry.npmjs.org/vows/-/vows-%{version}.tgz
# Custom man page
Source1:        vows.1
# Patch --supress-stdout to work with Node.js 8.x
Patch0:         nodejs-vows-supress-stdout.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  coffee-script
BuildRequires:  npm(diff)
BuildRequires:  npm(eyes)
BuildRequires:  npm(glob)
%endif
Source44: import.info

%description
Vows is an asynchronous behavior-driven development (BDD) framework for
Node.js.

Vows was built from the ground up to test asynchronous code. It
executes your tests in parallel when it makes sense, and sequentially
when there are dependencies. Emphasis was put on speed of execution,
clarity and user experience.


%prep
%setup -q -n package
%patch0 -p1

%nodejs_fixdep diff "^1.0.8"
%nodejs_fixdep glob "^6.0.3"
rm -rf node_modules


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/vows
cp -pr package.json lib/ %{buildroot}%{nodejs_sitelib}/vows
mkdir -p %{buildroot}%{nodejs_sitelib}/vows/bin
install -p -D -m0755 bin/vows %{buildroot}%{nodejs_sitelib}/vows/bin/vows
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/vows/bin/vows %{buildroot}%{_bindir}/vows
mkdir -p %{buildroot}%{_mandir}/man1
install -p -D -m0644 %{SOURCE1} %{buildroot}%{_mandir}/man1/vows.1
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
./bin/vows test/*.js
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/vows
%{_bindir}/vows
%{_mandir}/man1/vows.1*


%changelog
