Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename ware

# Tests currently disabled due to unhandled promise rejection
%global enable_tests 0

Name:		nodejs-ware
Version:	1.3.0
Release:	alt1_7
Summary:	Easily create your own middleware layer

License:	MIT
URL:		https://github.com/segmentio/ware
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(wrap-fn)

%if 0%{?enable_tests}
BuildRequires:	node-mocha
BuildRequires:	npm(co-mocha)
BuildRequires:	npm(gnode)
%endif
Source44: import.info

%description
Easily create your own middleware layer.


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package


# Create license file from end of Readme.md
sed -e '0,/^## License/d' Readme.md > LICENSE.md

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
mkdir -p node_modules/.bin/
ln -s %{_bindir}/mocha node_modules/.bin/mocha
mocha --require co-mocha \
	--require gnode \
	--reporter spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc History.md Readme.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}

%changelog
