Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-watchit
Version:    0.0.4
Release:    alt1_16
Summary:    A sensible wrapper around fs.watch for Node.js
# Upstream have been informed about missing LICENSE:
# https://github.com/TrevorBurnham/Watchit/issues/6
License:    MIT
URL:        https://github.com/TrevorBurnham/Watchit
Source0:    http://registry.npmjs.org/watchit/-/watchit-%{version}.tgz
Source1:    LICENSE
# Workaround fs.stat issue in nodejs 0.10
# Can be removed once nodejs is updated
# https://bugzilla.redhat.com/show_bug.cgi?id=1239735
Patch0:     nodejs-watchit-debounce.patch

%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif
BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(docco)

# Currently to compile the .coffee files, watchit depends on itself,
# which is not yet available.
%if 0%{?enable_tests}
BuildRequires:  coffee-script
BuildRequires:  npm(expect.js)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
cp -a %{SOURCE1} .
%patch0 -p1


%build
%{nodejs_sitelib}/docco/bin/docco ./src/watchit.coffee


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/watchit
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/watchit

%nodejs_symlink_deps


%files
%doc LICENSE README.mdown docs/
%{nodejs_sitelib}/watchit


%changelog
