Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename whet.extend

# Tests disabled due to large number of failures
# (that don't make any sense to the packager)
%global enable_tests 0

Name:		nodejs-whet-dot-extend
Version:	0.9.9
Release:	alt1_7
Summary:	A sharped version of port of jQuery.extend

License:	MIT
URL:		https://github.com/Meettya/whet.extend.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(coffee-script)
%if 0%{?enable_tests}
BuildRequires:	node-mocha
%endif

Requires:	node
Source44: import.info

%description
A sharped version of port of jQuery.extend that actually works on node.js


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package



%build
%nodejs_symlink_deps --build
mkdir -p node_modules/.bin/
ln -s %{_bindir}/coffee node_modules/.bin/coffee
rm lib/*.js
cake build
rm -rf node_modules/

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
mkdir -p node_modules/.bin/
ln -s %{_bindir}/coffee node_modules/.bin/coffee
ln -s %{_bindir}/mocha node_modules/.bin/mocha
/usr/bin/cake test
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
