Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
BuildRequires: perl(YAML.pm)
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename woothee
%global enable_tests 1

Name:		nodejs-woothee
Version:	1.4.0
Release:	alt1_8
Summary:	User-Agent string parser (js implementation)

License:	ASL 2.0
URL:		https://github.com/woothee/woothee-js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# No license file, requested at https://github.com/woothee/woothee-js/pull/7
Source1:	LICENSE-Apache2

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(js-yaml)

%if 0%{?enable_tests}
BuildRequires:	mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
User-Agent string parser (js implementation)


%prep
%setup -q -n package

cp -p %{SOURCE1} .

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ release/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE-Apache2
%doc *.md
%{nodejs_sitelib}/%{packagename}

%changelog
