Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename wrap-fn
# tests disabled due to missing dependencies
%global enable_tests 0

Name:		nodejs-wrap-fn
Version:	0.1.5
Release:	alt1_10
Summary:	Support sync, async, and generator functions

License:	MIT
URL:		https://github.com/matthewmueller/wrap-fn
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(co)

%if 0%{?enable_tests}
BuildRequires:	node-mocha
%endif
Source44: import.info

%description
Support sync, async, and generator functions


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package


# create the license file from the license section of Readme.md
sed -e '0,/^## License/d' Readme.md > LICENSE.md

%nodejs_fixdep co

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc Readme.md History.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}

%changelog
