Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0

%global barename xregexp

Name:               nodejs-xregexp
Version:            2.0.0
Release:            alt1_8
Summary:            Extended JavaScript regular expressions

License:            MIT
URL:                https://www.npmjs.org/package/xregexp
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(qunit)
%endif
Source44: import.info

%description
XRegExp provides augmented, extensible, cross-browser JavaScript regular
expressions. You get new syntax and flags beyond what browsers support
natively, along with a collection of utils to make your client-side
grepping and parsing easier. XRegExp also frees you from worrying about
pesky inconsistencies in cross-browser regex handling and the dubious
`lastIndex` property.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

# Fix line endings.
find . -exec dos2unix {} \;

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/xregexp
cp -pr package.json xregexp-all.js \
    %{buildroot}%{nodejs_sitelib}/xregexp

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
node tests/node-qunit.js
%endif


%files
%doc README.md MIT-LICENSE.txt
%{nodejs_sitelib}/xregexp/

%changelog
