Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: libelf-devel libnet-snmp-devel libseccomp-devel perl(ctime.pl) perl(sys/socket.ph) perl(timelocal.pl) texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global ntp_version 4.2.8p15

Name:		ntp-refclock
Version:	0.5
Release:	alt1_6
Summary:	Drivers for hardware reference clocks
# MIT is the primary license of ntp and ntp-refclock, but some drivers
# are licensed under BSD or BSD with advertising
License:	MIT and BSD and BSD with advertising
URL:		https://github.com/mlichvar/ntp-refclock
Source0:	https://github.com/mlichvar/ntp-refclock/archive/v%{version}/%{name}-%{version}.tar.gz
Source1:	http://www.eecis.udel.edu/~ntp/ntp_spool/ntp4/ntp-4.2/ntp-%{ntp_version}.tar.gz
Patch0:		ntp-reflock-configure-c99.patch

BuildRequires:	gcc libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit pps-tools-devel

Requires(pre):	shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Requires:	udev
%{?systemd_requires}

# The drivers and some code they need are from ntp
Provides:	bundled(ntp) = %{ntp_version}
Source44: import.info

%description
ntp-refclock is a wrapper for reference clock drivers included in the ntpd
daemon, which enables other NTP implementations to use the supported hardware
reference clocks for synchronization of the system clock.

It provides a minimal environment for the drivers to be able to run in a
separate process, measuring the offset of the system clock relative to the
reference clock and sending the measurements to another process controlling
the system clock.

%prep
%setup -q -a 1
ln -s ntp-%{ntp_version} ntp
# Avoid re-generating the configure scripts.
pushd ntp
preserve_timestamps="configure configure.ac sntp/configure sntp/m4/ntp_ipv6.m4"
for p in $preserve_timestamps ; do
    touch -r $p $p.timestamp
done
popd
%patch0 -p1 -b .c99
pushd ntp
for p in $preserve_timestamps ; do
    touch -r $p.timestamp $p
    rm $p.timestamp
done
popd

# Refer to packaged documentation for drivers
sed -i 's|<https:.*refclock.html>|in %{_docdir}/%{name}/drivers/|' ntp-refclock.8

%build
export CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing -fno-strict-overflow"

pushd ntp

%configure \
	--enable-all-clocks \
	--enable-parse-clocks \
	--disable-ATOM \
	--disable-LOCAL-CLOCK \
	--without-crypto \
	--without-threads \
	--without-sntp

# Build only objects that may be linked with ntp-refclock
%make_build -C libntp
%make_build -C libparse
cd ntpd
%make_build $(echo *refclock*.c | sed 's|\.c|\.o|g')

popd

%make_build \
	CFLAGS="$RPM_OPT_FLAGS" \
	LDFLAGS="$RPM_LD_FLAGS" \
	DEFAULT_USER=%{name} \
	DEFAULT_ROOTDIR=/usr/share/empty

%install
%makeinstall_std \
	sbindir=$RPM_BUILD_ROOT%{_sbindir} \
	mandir=$RPM_BUILD_ROOT%{_mandir}

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/{sysconfig,udev/rules.d}
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
install -m 644 -p examples/ntp-refclock.sysconfig \
	$RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/ntp-refclock
install -m 644 -p examples/ntp-refclock.rules \
	$RPM_BUILD_ROOT%{_sysconfdir}/udev/rules.d/80-ntp-refclock.rules
install -m 644 -p examples/ntp-refclock.service \
	$RPM_BUILD_ROOT%{_unitdir}/ntp-refclock.service
install -m 644 -p examples/pps-ldattach@.service \
	$RPM_BUILD_ROOT%{_unitdir}/pps-ldattach@.service
sed -i s,/sbin/ldattach,/usr/sbin/ldattach, %{buildroot}%{_unitdir}/pps-ldattach@.service

%pre
getent group %{name} >/dev/null || groupadd -r %{name}
getent passwd %{name} >/dev/null || \
	useradd -r -g %{name} -d / -s /sbin/nologin \
		-c "Reference clock driver" %{name}
:

%post
%post_service ntp-refclock

%preun
%preun_service ntp-refclock

%files
%doc --no-dereference COPYRIGHT*
%doc README NEWS ntp/html/drivers
%config(noreplace) %{_sysconfdir}/sysconfig/ntp-refclock
%config(noreplace) %{_sysconfdir}/udev/rules.d/80-ntp-refclock.rules
%{_sbindir}/%{name}
%{_mandir}/man8/%{name}.8*
%{_unitdir}/*.service

%changelog
