# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global systemctl_bin /usr/bin/systemctl

%define rel 4

Name: numad
Version: 0.5
Release: alt1_%rel.20150602git

Summary: NUMA user daemon

License: LGPLv2
Group: System/Kernel and hardware
URL: https://pagure.io/numad
# The source for this package was pulled from upstream's vcs.  Use the
# following commands to generate the tarball:
#   git clone https://pagure.io/numad.git numad-0.5git
#   tar --exclude-vcs -cJf numad-0.5git.tar.xz numad-0.5git/
Source0: %{name}-%{version}git.tar.xz

Requires: systemd-units
Requires(post): systemd-units
Requires(preun): systemd-units
BuildRequires: systemd-units
# (tv) for macros:
BuildRequires: libsystemd-devel systemd systemd-analyze systemd-boot-efi systemd-container systemd-coredump systemd-networkd systemd-portable systemd-sysvinit udev

ExcludeArch: s390 %{arm}
Source44: import.info

%description
Numad, a daemon for NUMA (Non-Uniform Memory Architecture) systems,
that monitors NUMA characteristics and manages placement of processes
and memory to minimize memory latency and thus provide optimum performance.

%prep
%setup -q -n %{name}-%{version}git

%build
make CFLAGS="$RPM_OPT_FLAGS -std=gnu99" LDFLAGS="$RPM_LD_FLAGS -lpthread -lrt -lm"

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
mkdir -p %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_mandir}/man8/
install -p -m 644 numad.service %{buildroot}%{_unitdir}/
install -p -m 644 numad.logrotate %{buildroot}%{_sysconfdir}/logrotate.d/%{name}
make install prefix=%{buildroot}/usr

%files
%{_bindir}/numad
%{_unitdir}/numad.service
%config(noreplace) %{_sysconfdir}/logrotate.d/numad
%doc %{_mandir}/man8/numad.8*

%post
%post_service numad
true

%preun
%preun_service numad
true

%postun
true



%changelog
