Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/gconftool-2 openmpi-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global		soversion	2.1

Name:		nvidia-texture-tools
Version:	2.1.2
Release:	alt1_2
Summary:	Collection of image processing and texture manipulation tools
License:	MIT and ASL 2.0 and BSD
URL:		https://github.com/castano/nvidia-texture-tools/wiki
Source0:	https://github.com/castano/%{name}/archive/%{version}.tar.gz
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:	ctest cmake
BuildRequires:	help2man
BuildRequires:	libjpeg-devel
BuildRequires:	libpng-devel libpng17-tools
BuildRequires:	libtiff-devel libtiffxx-devel
BuildRequires:	libopenjpeg-devel
BuildRequires:	libGL-devel
BuildRequires:	libGLU-devel

Patch0:		%{name}-libs.patch
Patch1:		%{name}-check.patch
Patch2:		%{name}-docs.patch
# add MIPS support
Patch3:		%{name}-mips.patch
# add S390 support
Patch4:		%{name}-s390.patch
# add PPCLE support
Patch5:		%{name}-ppcle.patch
# add aarch64 support
Patch6:		%{name}-aarch64.patch
# Do not presume SSE is available
Patch7:		%{name}-simd.patch
# Do not force compiler flags
Patch8:		%{name}-flags.patch
# Only implemented for x86
Patch9:		%{name}-debug.patch
Source44: import.info
ExcludeArch: %ix86

%description
The NVIDIA Texture Tools is a collection of image processing and texture
manipulation tools, designed to be integrated in game tools and asset
conditioning pipelines.

The primary features of the library are mipmap and normal map generation,
format conversion and DXT compression.

DXT compression is based on Simon Brown's squish library. The library also
contains an alternative GPU-accelerated compressor that uses CUDA and is
one order of magnitude faster.

%package	devel
Group: Development/Other
Summary:	Development libraries/headers for %{name}
Requires:	%{name} = %{version}-%{release}

%description	devel
Headers and libraries for development with %{name}.

%prep
%setup -q
%patch0 -p0
%patch1 -p0
%patch2 -p0
%patch3 -p0
%patch4 -p0
%patch5 -p0
%patch6 -p0
%patch7 -p0
%patch8 -p0
%ifnarch %{ix86} x86_64
%patch9 -p0
%endif

%build
%{fedora_v2_cmake} -DNVTT_SHARED=1 -DCMAKE_SKIP_RPATH=1	\
%ifnarch %{ix86} x86_64
	-DBUILD_SQUISH_WITH_SSE2=OFF		\
%endif
%if 0
%ifarch ppc64 ppc64le
	-DBUILD_SQUISH_WITH_ALTIVEC=ON		\
%endif
%endif

%fedora_v2_cmake_build

sed -e 's/\r//' -i LICENSE

%install
%fedora_v2_cmake_install
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man1
pushd $RPM_BUILD_ROOT/%{_bindir}
    export LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_libdir}:
    for bin in *; do
	help2man --no-info ./$bin > $RPM_BUILD_ROOT/%{_mandir}/man1/$bin.1
    done
popd

%check
export LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_libdir}:
%fedora_v2_ctest



%files
%doc --no-dereference LICENSE
%doc README.md
%{_bindir}/*
%{_libdir}/lib*.%{version}
%{_libdir}/lib*.%{soversion}
%{_mandir}/man1/*

%files		devel
%doc ChangeLog
%{_includedir}/nvtt
%{_libdir}/lib*.so

%changelog
