Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: libuuid-devel
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nwipe
Version:        0.36
Release:        alt1_1
Summary:        Securely erase disks using a variety of recognized methods


%global         gituser         martijnvanbrummelen
%global         gitname         nwipe
%global         commit          ab6c4c0014af7e423a4d90ca4e6f201cb30a1f98
%global         gitdate         20201209
%global         shortcommit     %(c=%{commit}; echo ${c:0:7})


License:        GPL-2.0-only
# used to be    http://nwipe.sourceforge.net
URL:            https://github.com/martijnvanbrummelen/nwipe
VCS:            https://github.com/martijnvanbrummelen/nwipe
# Releases      https://github.com/martijnvanbrummelen/nwipe/releases

#Source0:       https://github.com/%%{gituser}/%%{gitname}/archive/%%{commit}/%%{name}-%%{version}-%%{shortcommit}.tar.gz
Source0:        https://github.com/%{gituser}/%{gitname}/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz

# merged in
# https://github.com/martijnvanbrummelen/nwipe/pull/517
# Lower the build requirements to autoconf used in rhel6
# Patch1:         nwipe-epel6.patch

# merged in
# https://github.com/martijnvanbrummelen/nwipe/pull/516
# Move the usage of int64t bellow the stdint.h include which defines it
# Patch2:         nwipe-epel-int64t.patch

# merged in
# https://github.com/martijnvanbrummelen/nwipe/issues/519
# https://github.com/martijnvanbrummelen/nwipe/pull/520
# Move the time.h include in front od the _POSIX_SOURCE definition to fix build on rhel7
# time.h must be loaded before stdio.h
# Patch3:         nwipe-timespec.patch


BuildRequires:  gcc
BuildRequires:  libparted-devel
BuildRequires:  libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:  libconfig-c++-devel libconfig-devel
BuildRequires:  autoconf
BuildRequires:  automake

# Recommends only supported on fedora and rhel8+
%if (0%{?fedora}) || ( 0%{?rhel} && 0%{?rhel} >= 8 )
# used to provide serial number of drive over supported USB to SATA interface
Requires:     smartmontools smartmontools-update-drivedb
# provide SMBIOS/DMI host data to log file
Requires:     dmidecode
%endif
Source44: import.info


%description
The nwipe is a command that will securely erase disks using a variety of 
recognized methods. It is a fork of the dwipe command used by Darik's 
Boot and Nuke (dban). Nwipe was created out of need to run the DBAN dwipe
command outside of DBAN. This allows it to use any host distribution which
gives better hardware support. It is essentially the same as dwipe, with 
a few changes:
- pthreads is used instead of fork
- The parted library is used to detect drives
- The code is designed to be compiled with gcc
- Increased number of wipe methods
- Smartmontools is used to provide USB serial #
- DmiDecode is used to provide host info to nwipes log 

%prep
#autosetup -n %%{gitname}-%%{commit} -p 1
%setup -q -n %{gitname}-%{version}



%build

# On RHEL7 it is needed to explicitly pregress to c99 compatibility mode
%if 0%{?rhel} && 0%{?rhel} <= 7
export CFLAGS="%{optflags} -std=c99 -D_XOPEN_SOURCE=500"
%endif

autoreconf -vif

%configure
# make %%{?_smp_mflags}
%make_build


%install
# make install DESTDIR=%%{buildroot} LDFLAGS="-lncurses -lpanel"
%makeinstall_std


%files
%doc --no-dereference COPYING
%doc CHANGELOG.md README.md
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
