Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global provider        github
%global provider_tld    com
%global project         projectatomic
%global repo            oci-systemd-hook
# https://github.com/projectatomic/oci-systemd-hook
%global provider_prefix %{provider}.%{provider_tld}/%{project}/%{repo}
%global import_path     %{provider_prefix}
%global commit          05e692346ca73e022754332a7da641230dae2ffe
%global shortcommit     %(c=%{commit}; echo ${c:0:7})

Name:           %{repo}
Epoch:          1
Version:        0.2.0
Release:        alt1_2.git%{shortcommit}
# golang / go-md2man not available on ppc64
ExcludeArch:    ppc64
Summary:        OCI systemd hook for docker
License:        GPLv3+
URL:            https://%{import_path}
Source0:        https://%{import_path}/archive/%{commit}/%{name}-%{shortcommit}.tar.gz
BuildRequires:  gcc
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  pkgconfig(yajl)
BuildRequires:  pkgconfig(libselinux)
BuildRequires:  pkgconfig(mount)
BuildRequires:  libpcre-devel libpcrecpp-devel
BuildRequires:  go-md2man
Obsoletes:      %{name} <= 1.10.3-46
Source44: import.info

%description
OCI systemd hooks enable running systemd in a OCI runc/docker container.

%prep
%setup -q -n %{name}-%{commit}

%build
aclocal
autoreconf -i
%configure --libexecdir=%{_libexecdir}/oci/hooks.d/
%make_build

%install
%makeinstall_std

#define license tag if not already defined
%{!?_licensedir:%global license %doc}

%files
%doc README.md
%doc --no-dereference LICENSE
%{_mandir}/man1/%{name}.1*
%dir %{_libexecdir}/oci
%dir %{_libexecdir}/oci/hooks.d
%{_libexecdir}/oci/hooks.d/%{name}
%dir %{_usr}/share/containers/oci/hooks.d
%{_usr}/share/containers/oci/hooks.d/oci-systemd-hook.json

%changelog
