# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname   advent

Name:           open-adventure
Version:        1.9
Release:        alt1_2
Summary:        Forward-port of Colossal Cave Adventure 2.5 from 1995
Group:          Games/Adventure
License:        BSD-2-Clause
URL:            http://www.catb.org/~esr/open-adventure/
Source0:        http://www.catb.org/~esr/open-adventure/%{oname}-%{version}.tar.gz

BuildRequires:  pkgconfig(libedit)
BuildRequires:  python3 python3-tools
BuildRequires:  python3-module-yaml
Source44: import.info

%description
Colossal Cave Adventure, the 1995 430-point version.

This is the last descendent of the original 1976 Colossal Cave Adventure
worked on by the original authors - Crowther & Woods.  It has sometimes
been known as Adventure 2.5.  The original PDP-10 name 'advent' is used
for the built program to avoid collision with the BSD Games version (see
'adventure' in the bsd-games package).

%prep
%setup -q -n %{oname}-%{version}


%build

export CCFLAGS="$CFLAGS"
%make_build

%install
install -D -m755 advent %{buildroot}%{_bindir}/advent
ln -s advent %{buildroot}%{_bindir}/%{name}

install -D -m644 advent.6 %{buildroot}%{_mandir}/man6/advent.6
ln -s advent.6 %{buildroot}%{_mandir}/man6/%{name}.6

%files
%doc *.adoc NEWS
%doc --no-dereference COPYING
%{_bindir}/advent
%{_bindir}/%{name}
%{_mandir}/man6/advent.6*
%{_mandir}/man6/%{name}.6*


%changelog
