# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libGL-devel libcurl-devel libsqlite3-devel openmpi-devel python3-devel rpm-build-python3 unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define piname	aisradar_pi
%define uname	AISradar_pi

Name:		opencpn-ais-radar-plugin
Summary:	AIS radar view plugin for OpenCPN
Version:	1.4.10.0
Release:	alt1_1
License:	GPLv2
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/aisradarview.html
Source0:	https://github.com/rgleason/%{uname}/archive/v%{version}/%{uname}-%{version}.tar.gz
#download https://github.com/OpenCPN/opencpn-libs/archive/7ea37a15682c432df63ca7a25967954a8f9f13ad.zip
Source1:    opencpn-libs-7ea37a15682c432df63ca7a25967954a8f9f13ad.zip
Patch0:     opencpn-libs-7ea37a15-tinyxml.patch
Patch1:     opencpn-libs-7ea37a15-json.patch
Patch2:     aisradar-PluginConfigure.patch


BuildRequires:	ccmake cmake ctest
BuildRequires:	gettext gettext-tools
BuildRequires:	git
BuildRequires:	libwxBase3.2-devel libwxGTK3.2-devel
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:  pkgconfig(jsoncpp)

Requires:		opencpn
Provides:		%{piname} = %{version}
Source44: import.info

%description
AIS Radar is a plugin that allows the display of AIS targets in the way ships
are displayed on a radar screen.

North up, course up displays.

Includes the "Anchor" branch from TransmitterDan, which shows a black ball on
all AIS Class A vessels that are anchored or moored.

%prep
%setup -q -a1 -n %{uname}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


mv  opencpn-libs-7ea37a15682c432df63ca7a25967954a8f9f13ad/{.,}* opencpn-libs/

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%find_lang opencpn-%{piname}

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/


%changelog
