# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libGL-devel libcurl-devel libsqlite3-devel openmpi-devel python3-devel rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global gdate	20231108
%global commit0 f91c3f6bce1082af865b092d404811837e1e4a03
%define piname	celestial_navigation_pi
%global  _disable_ld_as_needed 1
%global rel 1

Name:		opencpn-celestial-navigation-plugin
Summary:	Celestial Navigation plugin for OpenCPN
Version:	2.4.40.0
Release:	alt1_1.git20231108.1
License:	GPLv3+
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/celestialnav.html
%if 0%{!?gdate:1}
Source0:	https://github.com/rgleason/%{piname}/archive/v%{version}/%{piname}-%{version}.tar.gz
%else
Source0:	 https://github.com/rgleason/%{piname}/archive/%{commit0}/%{piname}-%{commit0}.tar.gz
%endif
#download https://github.com/OpenCPN/opencpn-libs/archive/refs/tags/main@257338e.tar.gz
Source1:    opencpn-libs-main-257338e.tar.gz
Patch0:     opencpn-libs-257338e-tinyxml.patch
Patch1:     opencpn-libs-257338e-json.patch
Patch2:     celestial-PluginConfigure.patch

BuildRequires:	ccmake cmake ctest
BuildRequires:	gettext gettext-tools
BuildRequires:	libwxBase3.2-devel libwxGTK3.2-devel
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:  pkgconfig(jsoncpp)

Requires:	opencpn
Provides:   %{piname} = %{version}
Source44: import.info

%description
Implements nautical almanac for sun, moon, planets and various
navigational stars.

Enables the user to compute a position fix from celestial measurements.

%prep
%setup -q -a1 -n %{piname}-%{?commit0}%{!?commit0:%version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


mv opencpn-libs-main-257338e/{.,}* opencpn-libs/

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%find_lang opencpn-%{piname}

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/


%changelog
