# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define piname	objsearch_pi

Name:		opencpn-objsearch-plugin
Summary:	Chart Object Search plugin for OpenCPN
Version:	0.21
Release:	alt4_9
License:	GPLv3+
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/chartobject.html
Source0:	https://github.com/nohal/%{piname}/archive/v%{version}/%{piname}-%{version}.tar.gz

BuildRequires:	cmake
BuildRequires:	gettext gettext-tools
BuildRequires:	libwxGTK3.0-devel < 3.1
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(tinyxml)

Requires:	opencpn
Provides:	%{piname} = %{version}
Source44: import.info

%description
Allows search of named objects on S-57 s63 and CM93 vector charts.

Note: After the installation, the plug-in does not know anything about your
charts, you must view a chart at least once to populate the plug-in's database
with it's content.
This one time operation makes OpenCPN slower, however during subsequent views
of the same chart the speed of the application is unaffected.
Once the database is populated, the charts are no longer needed, so if you
prefer to use raster charts, you can populate the database from the ENC
chartset and then switch back to RNC charts and the search capabilities will
still be available.

%prep
%setup -q -n %{piname}

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%find_lang opencpn-%{piname}

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/data/


%changelog
